"""Multi user daemon."""
import uweb
import os

__author__ = 'Arjen Pander <arjen@underdark.nl>'
__version__ = '0.1'

class MultiDaemon(uweb.DebuggingPageMaker):
  """Multi user daemon."""

  COMPLETED = 'COMPLETED'

  def Index(self, action=None):
    """Returns the homepage and performs the optional action."""
    user = self.post.getfirst('user', None)
    hostname = self.post.getfirst('hostname', None)
    result = None
    if action == 'add':
      if hostname is not None and user is not None:
        result = self.CreateUser(user, hostname)
    if action == 'remove':
      if user is not None:
        result = self.RemoveUser(user)
    if result is not None and result != MultiDaemon.COMPLETED:
      return result
    else:
      users = self.GetUsers()
      return self.parser.Parse('index.html', users=users)

  def GetUsers(self):
    """Returns a list of the current users."""
    return os.listdir('/home')

  def CreateUser(self, user, hostname):
    """Creates a new user based on the given information."""
    args = ["/root/createuser.sh", user, hostname]
    return self.PerformAction('create user', args)

  def RemoveUser(self, user):
    """Removes the user based on the given information."""
    args = ["/root/removeuser.sh", user]
    return self.PerformAction('remove user', args)

  def PerformAction(self, action, args):
    """Performs the given action with the given arguments."""
    try:
      os.system(' '.join(args))
    except OSError as e:
      return self.ErrorPage(e, action)
    else:
      return MultiDaemon.COMPLETED

  def NotFound(self):
    """Returns a 404 page."""
    return uweb.Response('Document not found. API version %s' % __version__, httpcode=404)

  def ErrorPage(self, error, call=''):
    """Returns an error page."""
    return uweb.Response('The %s call caused the following error: %r' % (call, error), httpcode=500)


PACKAGE = 'MultiDaemon'
PAGE_CLASS = MultiDaemon
CONFIG = '/var/www/multidaemon.conf'
ROUTES = [('/', 'Index'),
          ('/(add)user', 'Index'),
          ('/(remove)user', 'Index'),
          ('(/styles/.*)', 'Static'),
          ('.*', 'NotFound')]

uweb.ServerSetup(apache_logging=False)
