#!/bin/bash

if [ $# != 1 ] ; then
    echo usage: $0 '<user>'
    exit 1
fi

# the SUFFIX must not contain spaces or shell meta characters
SUFFIX=$1

systemctl stop apache2@$SUFFIX.service
systemctl disable apache2@$SUFFIX.service

echo Deleting user
deluser $SUFFIX --remove-home
delgroup $SUFFIX

echo Deleting apache log files
rm -rf /var/log/apache2-$SUFFIX

echo Deleting apache config
rm -rf /etc/apache2-$SUFFIX
a2dissite $SUFFIX-proxy
rm -f /etc/apache2/sites-available/$SUFFIX-proxy.conf
systemctl reload apache2.service

echo Deleting apache bin symlinks
for a in a2enmod a2dismod a2ensite a2dissite a2enconf a2disconf apache2ctl ; do
  echo -n " $a-$SUFFIX"
    unlink /usr/local/sbin/$a-$SUFFIX
done
echo

rm -rf /etc/php/7.2/fpm/pool.d/$SUFFIX.conf
